---
-- Name: AID-008 - AI_A2A - CAP Grouping Test
-- Author: FlightControl
-- Date Created: 06 Aug 2017


-- Define a SET_GROUP object that builds a collection of groups that define the EWR network.
-- Here we build the network with all the groups that have a name starting with DF CCCP AWACS and DF CCCP EWR.
DetectionSetGroup_RED = SET_GROUP:New()
DetectionSetGroup_RED:FilterPrefixes("107", "109" ,"REDEWR")
DetectionSetGroup_RED:FilterStart()
Detection_RED = DETECTION_AREAS:New( DetectionSetGroup_RED, 300000 )
Detection_RED:SetRefreshTimeInterval( 10 )

A2ADispatcher_RED = AI_A2A_DISPATCHER:New( Detection_RED )
A2ADispatcher_RED:SetEngageRadius( 110000 )

MainRedZone = ZONE_POLYGON:New( "MainRedZone", GROUP:FindByName( "MainRedZone" ) )
NorthRedZone = ZONE_POLYGON:New( "NorthRedZone", GROUP:FindByName( "NorthRedZone" ) )
WestRedZone = ZONE_POLYGON:New( "WestRedZone", GROUP:FindByName( "WestRedZone" ) )

REDBARCAPNORTH = ZONE_POLYGON:New( "REDBARCAPNORTH", GROUP:FindByName( "REDBARCAPNORTH" ) )
SouthRedZone = ZONE_POLYGON:New( "SouthRedZone", GROUP:FindByName( "SouthRedZone" ) )
REDBARCAPSOUTH = ZONE_POLYGON:New( "REDBARCAPSOUTH", GROUP:FindByName( "REDBARCAPSOUTH" ) )
DeepRedZone = ZONE_POLYGON:New( "DeepRedZone", GROUP:FindByName( "DeepRedZone" ) )
SirjanRed = ZONE_POLYGON:New( "SirjanRed", GROUP:FindByName( "SirjanRed" ) )
REDContested = ZONE_POLYGON:New( "REDContested", GROUP:FindByName( "REDContested" ) )

A2ADispatcher_RED:SetBorderZone( MainRedZone )

--------------------////CAP Squadrons 

--Border
A2ADispatcher_RED:SetSquadron( "ShirazCAP", AIRBASE.PersianGulf.Shiraz_International_Airport, { "Su25", "Su17", "Su24"}, 8 )
A2ADispatcher_RED:SetSquadron( "ShirazIntercept", AIRBASE.PersianGulf.Shiraz_International_Airport, { "Mig21","Mig25", "Mig29S", "REDF1"}, 6 )

A2ADispatcher_RED:SetSquadron( "KermanIntercept", AIRBASE.PersianGulf.Kerman_Airport, { "REDM2000C", "Mig25", "Mig29S", "Su27", "F16A" , "REDF1"}, 15 )
A2ADispatcher_RED:SetSquadron( "KermanBARCAP", AIRBASE.PersianGulf.Kerman_Airport, { "F14A", "Mig31"}, 8 )
A2ADispatcher_RED:SetSquadron( "KermanBIGDADDY", AIRBASE.PersianGulf.Kerman_Airport, { "Su17", "Su24", "Su34", "Tu22" }, 5 )

A2ADispatcher_RED:SetSquadron( "JiroftIntercept", AIRBASE.PersianGulf.Jiroft_Airport, { "Mig21","Mig23", "REDM2000C", "F5E3", "REDF1", "Mig25" }, 10 )

A2ADispatcher_RED:SetSquadron( "BandarIntercept", AIRBASE.PersianGulf.Bandar_Abbas_Intl, { "REDM2000C", "Mig25", "Mig29S","Su27", "F16A" }, 15 )
A2ADispatcher_RED:SetSquadron( "BandarBARCAP", AIRBASE.PersianGulf.Bandar_Abbas_Intl, { "F14A", "Mig31"}, 8 )
A2ADispatcher_RED:SetSquadron( "BandarBIGDADDY", AIRBASE.PersianGulf.Bandar_Abbas_Intl, { "Su17", "Su24", "Su34", "Tu22" }, 5 )

A2ADispatcher_RED:SetSquadron( "FujairahCARGO", AIRBASE.PersianGulf.Fujairah_Intl, { "IL76MD" ,"REDAn26B" }, 8 )


--These are all airbases of the Persion Gulf Map:

--AIRBASE.PersianGulf.Abu_Dhabi_International_Airport
--AIRBASE.PersianGulf.Abu_Musa_Island_Airport
--AIRBASE.PersianGulf.Al-Bateen_Airport
--AIRBASE.PersianGulf.Al_Ain_International_Airport
--AIRBASE.PersianGulf.Al_Dhafra_AB
--AIRBASE.PersianGulf.Al_Maktoum_Intl
--AIRBASE.PersianGulf.Al_Minhad_AB
--AIRBASE.PersianGulf.Bandar_e_Jask_airfield
--AIRBASE.PersianGulf.Bandar_Abbas_Intl
--AIRBASE.PersianGulf.Bandar_Lengeh
--AIRBASE.PersianGulf.Dubai_Intl
--AIRBASE.PersianGulf.Fujairah_Intl
--AIRBASE.PersianGulf.Havadarya
--AIRBASE.PersianGulf.Jiroft_Airport
--AIRBASE.PersianGulf.Kerman_Airport
--AIRBASE.PersianGulf.Khasab
--AIRBASE.PersianGulf.Kish_International_Airport
--AIRBASE.PersianGulf.Lar_Airbase
--AIRBASE.PersianGulf.Lavan_Island_Airport
--AIRBASE.PersianGulf.Liwa_Airbase
--AIRBASE.PersianGulf.Qeshm_Island
--AIRBASE.PersianGulf.Ras_Al_Khaimah_International_Airport
--AIRBASE.PersianGulf.Sas_Al_Nakheel_Airport
--AIRBASE.PersianGulf.Sharjah_Intl
--AIRBASE.PersianGulf.Shiraz_International_Airport
--AIRBASE.PersianGulf.Sir_Abu_Nuayr
--AIRBASE.PersianGulf.Sirri_Island
--AIRBASE.PersianGulf.Tunb_Island_AFB
--AIRBASE.PersianGulf.Tunb_Kochak

--------------------////Altitude

A2ADispatcher_RED:SetDefaultTakeoffInAirAltitude( 500 )

--------------------////TAKEOFF
--Border
A2ADispatcher_RED:SetSquadronTakeoffFromParkingHot( "ShirazCAP" )
A2ADispatcher_RED:SetSquadronTakeoffInAir( "ShirazIntercept" )


A2ADispatcher_RED:SetSquadronTakeoffInAir( "KermanIntercept" )
A2ADispatcher_RED:SetSquadronTakeoffInAir( "KermanBARCAP" )
A2ADispatcher_RED:SetSquadronTakeoffFromParkingCold( "KermanBIGDADDY" )


A2ADispatcher_RED:SetSquadronTakeoffInAir( "JiroftIntercept" )


A2ADispatcher_RED:SetSquadronTakeoffInAir( "BandarIntercept" )
A2ADispatcher_RED:SetSquadronTakeoffInAir( "BandarBARCAP" )
A2ADispatcher_RED:SetSquadronTakeoffFromParkingCold( "BandarBIGDADDY" )


A2ADispatcher_RED:SetSquadronTakeoffInAir( "FujairahCARGO" )


--------------------////LANDING
A2ADispatcher_RED:SetSquadronLandingNearAirbase( "ShirazCAP" )
A2ADispatcher_RED:SetSquadronLandingNearAirbase( "ShirazIntercept" )


A2ADispatcher_RED:SetSquadronLandingNearAirbase( "KermanIntercept" )
A2ADispatcher_RED:SetSquadronLandingAtEngineShutdown( "KermanBARCAP" )
A2ADispatcher_RED:SetSquadronLandingNearAirbase( "KermanBIGDADDY" )


A2ADispatcher_RED:SetSquadronLandingNearAirbase( "JiroftIntercept" )


A2ADispatcher_RED:SetSquadronLandingNearAirbase( "BandarIntercept" )
A2ADispatcher_RED:SetSquadronLandingAtEngineShutdown( "BandarBARCAP" )
A2ADispatcher_RED:SetSquadronLandingAtEngineShutdown( "BandarBIGDADDY" )


A2ADispatcher_RED:SetSquadronLandingNearAirbase( "FujairahCARGO" )



--------------------Timing Originally 300/750
A2ADispatcher_RED:SetSquadronCap( "ShirazCAP", REDContested, 1000, 10000, 600, 900, 700, 1200, "BARO" )
A2ADispatcher_RED:SetSquadronCapInterval( "ShirazCAP", 1, 1, 1200, 1 )
A2ADispatcher_RED:SetSquadronGci( "ShirazIntercept", 700, 1000 )

A2ADispatcher_RED:SetSquadronGci( "KermanIntercept", 900, 1200 )
A2ADispatcher_RED:SetSquadronCap( "KermanBARCAP", REDBARCAPNORTH, 9000, 12000, 700, 900, 900, 1500, "BARO" )
A2ADispatcher_RED:SetSquadronCapInterval( "KermanBARCAP", 2, 1, 400, 1) 
A2ADispatcher_RED:SetSquadronCapRacetrack("KermanBARCAP", 20000, 25000, 3, 5, 214*234, 30*60)
A2ADispatcher_RED:SetSquadronCap( "KermanBIGDADDY", DeepRedZone,  3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_RED:SetSquadronCapInterval( "KermanBIGDADDY", 1, 1, 1200, 1 )


A2ADispatcher_RED:SetSquadronGci( "JiroftIntercept", 900, 1200 )

A2ADispatcher_RED:SetSquadronCap( "BandarBARCAP", REDBARCAPSOUTH, 9000, 12000, 700, 900, 900, 1500, "BARO" )
A2ADispatcher_RED:SetSquadronCapInterval( "BandarBARCAP", 2, 1, 400, 1) 
A2ADispatcher_RED:SetSquadronCapRacetrack("BandarBARCAP", 20000, 25000, 3, 5, 270*280, 30*60)
A2ADispatcher_RED:SetSquadronGci( "BandarIntercept", 900, 1200 )
A2ADispatcher_RED:SetSquadronCap( "BandarBIGDADDY", DeepRedZone,  3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_RED:SetSquadronCapInterval( "BandarBIGDADDY", 1, 1, 1200, 1 )


A2ADispatcher_RED:SetSquadronCap( "FujairahCARGO", DeepRedZone, 1000, 10000, 750, 900, 800, 1200, "BARO" )
A2ADispatcher_RED:SetSquadronCapInterval( "FujairahCARGO", 1, 1, 1200, 1 )


--------------------////SQUADRON GROUPING
A2ADispatcher_RED:SetSquadronGrouping( "ShirazCAP", 2 )
A2ADispatcher_RED:SetSquadronGrouping( "ShirazIntercept", 1 )



A2ADispatcher_RED:SetSquadronGrouping( "KermanIntercept", 2 )
A2ADispatcher_RED:SetSquadronGrouping( "KermanBARCAP", 1 )
A2ADispatcher_RED:SetSquadronGrouping( "KermanBIGDADDY", 1 )


A2ADispatcher_RED:SetSquadronGrouping( "JiroftIntercept", 2 )


A2ADispatcher_RED:SetSquadronGrouping( "BandarIntercept", 2 )
A2ADispatcher_RED:SetSquadronGrouping( "BandarBARCAP", 1 )
A2ADispatcher_RED:SetSquadronGrouping( "BandarBIGDADDY", 1 )


A2ADispatcher_RED:SetSquadronGrouping( "FujairahCARGO", 1 )


--------------------////SQUADRON OVERHEAD (1.0-1.5)
A2ADispatcher_RED:SetSquadronOverhead( "ShirazCAP", 0.5)
A2ADispatcher_RED:SetSquadronOverhead( "ShirazIntercept", 0.5)


A2ADispatcher_RED:SetSquadronOverhead( "KermanIntercept", 1)
A2ADispatcher_RED:SetSquadronOverhead( "KermanBARCAP", 0.5)
A2ADispatcher_RED:SetSquadronOverhead( "KermanBIGDADDY", 1.0)


A2ADispatcher_RED:SetSquadronOverhead( "JiroftIntercept", 1.2)


A2ADispatcher_RED:SetSquadronOverhead( "BandarIntercept", 1)
A2ADispatcher_RED:SetSquadronOverhead( "BandarBARCAP", 1)
A2ADispatcher_RED:SetSquadronOverhead( "BandarBIGDADDY", 1.0)


A2ADispatcher_RED:SetSquadronOverhead( "FujairahCARGO", 2.0)


-------------------- RTB ON FUEL
A2ADispatcher_RED:SetSquadronFuelThreshold( "ShirazCAP", 0.50 )
A2ADispatcher_RED:SetSquadronFuelThreshold( "ShirazIntercept", 0.50 )

A2ADispatcher_RED:SetSquadronFuelThreshold( "KermanIntercept", 0.50 )


A2ADispatcher_RED:SetSquadronFuelThreshold( "KermanIntercept", 0.50 )
A2ADispatcher_RED:SetSquadronFuelThreshold( "KermanBARCAP", 0.30 )
A2ADispatcher_RED:SetSquadronFuelThreshold( "KermanBIGDADDY", 0.50 )


A2ADispatcher_RED:SetSquadronFuelThreshold( "JiroftIntercept", 0.50 )


A2ADispatcher_RED:SetSquadronFuelThreshold( "BandarIntercept", 0.50 )
A2ADispatcher_RED:SetSquadronFuelThreshold( "BandarBARCAP", 0.30 )
A2ADispatcher_RED:SetSquadronFuelThreshold( "BandarBIGDADDY", 0.50 )


A2ADispatcher_RED:SetSquadronFuelThreshold( "FujairahCARGO", 0.50 )
